﻿#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3
#pragma IgorVersion = 8
#pragma version = 4.00
#pragma hide=1
#pragma DefaultTab={3,20,4}

// updates
// - see report on IgorExchange

#include ":Supporting:Image Tools Headers"
#include ":Supporting:Image Tools Structures"
#include ":Supporting:Image Tools Controls"
#include ":Supporting:Image Tools Display"
#include ":Supporting:Image Tools Load"
#include ":Supporting:Image Tools Analyze"
#include ":Supporting:Image Tools Calibrate"
#include ":Supporting:Image Tools Process"
#include ":Supporting:Image Tools Background"
#include ":Supporting:Image Tools Threshold"
#include ":Supporting:Image Tools Mask"
#include ":Supporting:Image Tools Crop"
#include ":Supporting:Image Tools Publish"
#include ":Supporting:Image Tools Math"

Static StrConstant k_strversion = "4.00"
Static Constant k_version = 4.00

// ***
// Updater Package

Static StrConstant ksShortTitle="Image Tools"
static Constant kProjectID=21002

// menu placement
Menu "Analysis"
	"Image Tools", /Q, init_StartImageTools()
end

// after compiling
Function AfterCompiledHook()
	// does the data folder exist?
	if (DataFolderExists(k_fullPackageFolder))
		// has the package been updated?
		if (imgT_Update() > 0)
			init_createGUIs(0)
		endif
	endif	
	return 1
end

// ***
// STARTUP
// start image tools
// - confirm screen size
// - initialize package folder
// - update package
// - create GUIs

// starting point from menu call
Function init_StartImageTools()

	variable first = 0
	
	// screen height check
	if (init_CheckScreen() < 0)
		return 0
	endif
	
	// initialize or update?	
	if (!DataFolderExists(k_fullpackageFolder))
		init_InitializePackage()
		first = 1
	else
		imgT_Update()
	endif

	// create the GUIs
	init_CreateGUIs(first)
	return 0
end

// check screen height
Static Function init_CheckScreen()

	variable rtn = 0, nitems

	variable first = 0, sheight
	string sinfo, scrwarning
	
	sinfo = StringbyKEY("SCREEN1",IgorInfo(0))
	nitems = ItemsInList(sinfo,",")
	sinfo = StringFromList(nitems-1,sinfo,",")
	sheight = str2num(sinfo)
	
	if (sheight < k_minscreenh)
		scrwarning = "This package is recommended for a screen with a minimum height of " + num2str(k_minscreenh)
		scrwarning += " pixels. Change your screen resolution and try again."
		DoAlert/T="Screen Size Too Small" 0, scrwarning
		rtn = -1
	endif
	
	return rtn
end

// initialize the package folder
Static Function init_InitializePackage([variable imgonly])

	if (ParamIsDefault(imgonly))
		// create package folder
		SetDataFolder root:	
		NewDataFolder/O/S Packages	
		NewDataFolder/O/S $k_packageFolder
		// create globals
		// working directory
		string/G cwdfolder = "Packages:imgT", cwfile = "img_default"
		make/N=1/O scalewx, scalewy, scaledx
		make/N=101/D/O mqprofile = NaN
		variable/G k_imgTVersion = k_version
		NewDataFolder/O contactprint
	else
		SetDataFolder root:Packages:$k_packageFolder
	endif
	
	make/O/N=(600,400)/B/U img_default
	img_default = 200*sin(x/30)*cos(y/30)+200
	
	SetDataFolder root:
	string tstr
	tstr = " - Installed Image Tools version " + k_strversion
	print f_DateTimeStamp() + tstr

	return 0
end

// updates occur within the imgT package folder
Static Function imgT_Update()
	
	DFREF fpf = $k_fullPackageFolder
	NVAR/Z/SDFR=fpf k_imgTVersion

	string astr, estr, tstr
	astr = ""
	estr = "\r\rThe image window and panel will close and reopen.\rSettings may change, but data will not change."
	variable how = 0
	
	if (!NVAR_Exists(k_imgTVersion))
		astr = "Updating current undefined version of \rImage Tools to version " + k_strversion + ".\r\r"
		how = 1
	elseif (k_imgTVersion != k_version)
		astr = "Updating old version of Image Tools " + num2str(k_imgTVersion) + " to newer version " + k_strversion + "."
		how = 1
	endif
	
	// update block
	if (how == 1)		
		print date() + " " + Secs2Time(DateTime,3) + " " + astr
		astr += estr
		DoAlert/T="Updating Image Tools", 0, astr
		DoWindow/K imgT_display
		DoWindow/K k_histGraphs
		DFREF cdf = GetDataFolderDFR()
		SetDataFolder fpf
		strswitch(k_strversion)
			default:
				if (!NVAR_Exists(k_imgTVersion))
					variable/G k_imgTVersion
				endif
				NVAR k_imgTVersion
				k_imgTVersion = k_version
				wave/Z scalewx
				if (!WaveExists(scalewx))
					make/N=1 scalewx, scalewy, scaledx
				endif
				wave/Z ww = img_default
				if (!WaveExists(ww))
					make/N=(600,400)/B/U img_default
				endif
				ww = 200*sin(x/30)*cos(y/30)+200
				print astr
				break
		endswitch
		SetDataFolder cdf		
		NVAR/SDFR=fpf k_imgTVersion
		k_imgTVersion = k_version
	endif
	
	return how
end

// create the GUIs
Static Function init_CreateGUIs(variable first)
	
	string lwfile, tstr
	// bring window forward or create?
	DoWindow/F $k_imgDisplay
	if (v_flag == 0)
		// validate working folder and file
		DFREF pf = $k_fullpackageFolder
		SVAR/SDFR=pf cwdfolder, cwfile
		// if not first time, check that we have not crashed previous case
		if (!first)
			lwfile = "root:" + cwdfolder + ":" + cwfile
			wave/Z swave = $lwfile
			if (!waveExists(swave))
				// previous image no longer exists
				// default back to default image
				cwdfolder = StringFromList(0,f_LoimgT())
				cwfile = "img_" + StringFromList(0,f_LoimgF(sfolder=cwdfolder, all=1))
				lwfile =  "root:" + cwdfolder + ":" + cwfile
				wave/Z swave = $lwfile
				if (!WaveExists(swave))
					// we have crashed Image Tools back to the default
					// restart from here
					init_InitializePackage(imgonly=1)
					cwdfolder = "Packages:imgT"
					cwfile = "img_default"
				endif
			endif
		endif
		// create new windows
		disp_CreateImageWindow(0)
		disp_ShowHistograms(0)
		disp_AppendImageToolsPanel(0)
		// initialize the tabs
		if (f_NImagesLoaded() == 0)
			disp_InitializeTabMenus(-1)
		else
			disp_InitializeTabMenus(100)
			T3_UpdateContactPrint()
		endif
		// set hooks and update control bar
		disp_SetHookFunctions()
		disp_UpdateControlBar()
		// print notice
		tstr = f_DateTimeStamp() + " - Starting Image Tools version " + k_strversion
		print tstr
	endif
		
	return 0
end